//---------------------------------------------------------------------------
//
//    Marian Wybraczyk (C) 2003, 2004, 2005
//
//		Interfejs bazodanowy opracowany dla ADO - MS SQL Server 2000
//
//		Obsluga Transakcji domyslnie WYCZONA [patrz ExecSQL() ]
//
//---------------------------------------------------------------------------
#pragma hdrstop

// musi by podczenie do DataModule
#include "DataModule.h"

#include "UTabela.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)

//---------------------------------------------------------------------------
__fastcall MTabela::MTabela()
{
	// tylko wskazanie na komponent z DataModule
	ADOConnection      = DM->ADOConnection;

   LQ                 = new TADOQuery(NULL);
   LQ->Name           = "LOCAL_ADOQUERY";
   LQ->Connection     = ADOConnection;
	LQ->CommandTimeout = 60;
   LQ->SQL->Clear();
   sql_txt            = "";
}
//---------------------------------------------------------------------------
__fastcall MTabela::~MTabela()
{
   LQ->Close();
   delete LQ;
   LQ = NULL;
}
//---------------------------------------------------------------------------
bool MTabela::Eof()
{
   return LQ->Eof;
}
//---------------------------------------------------------------------------
void MTabela::First()
{
   LQ->First();
}
//---------------------------------------------------------------------------
void MTabela::Next()
{
   LQ->Next();
}
//---------------------------------------------------------------------------
void MTabela::Close()
{
   LQ->Close();
}
//---------------------------------------------------------------------------
Longint MTabela::RecordCount()
{
   return LQ->RecordCount;
}
//---------------------------------------------------------------------------
bool MTabela::Open()
{
   /*
   SQL text jest ju ustawiony, parametry rwnie
   otwieram kursor oraz ustawiam RecordCount
   */

   bool ret = true;

   IlRek = 0;           // wynik operacji Select - ile rekordw go spenia
   
   try
   {
      Application->ProcessMessages();
      LQ->Open();
      IlRek = RecordCount();
   }
   catch(...)
   {
      ret = false;
      ShowMessage("Bd wykonania instrukcji Open");
   }
   return ret;
}
//---------------------------------------------------------------------------
bool MTabela::ExecSQL(bool WlaczycTransakcje)
{
   bool       trwa_transakcja = false;
   bool       ret             = true;

   // SQL text jest ju ustawiony, parametry rwnie
   trwa_transakcja = ADOConnection->InTransaction;

   try
   {
      if(WlaczycTransakcje)
      {
         if(! trwa_transakcja)
         {
            ADOConnection->BeginTrans();
         }
      }

      LQ->ExecSQL();


      if(WlaczycTransakcje)
      {
         ADOConnection->CommitTrans();
      }
   }
   catch(...)
   {
      if(WlaczycTransakcje)
      {
         ADOConnection->RollbackTrans();
         ShowMessage("Transakcja wycofana");
      }
      ret = false;

      ShowMessage("Bd wykonania funkcji ExecSQL");
   }
   return ret;
}
//---------------------------------------------------------------------------

